/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.network.handler;

import com.google.common.collect.ImmutableList;
import com.redpxnda.respawnobelisks.config.CurseConfig;
import com.redpxnda.respawnobelisks.registry.ModRegistries;
import com.redpxnda.respawnobelisks.registry.particle.RuneCircleParticle;
import com.redpxnda.respawnobelisks.registry.particle.RuneCircleType;
import com.redpxnda.respawnobelisks.util.ClientUtils;
import com.redpxnda.respawnobelisks.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class S2CHandlers {
    public static void setupRuneCircleRenderPacket(boolean kill, int age, double x, double y, double z) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        ImmutableList pos = ImmutableList.of((Object)x, (Object)y, (Object)z);
        if (ClientUtils.activeRuneParticles.containsKey(pos)) {
            RuneCircleParticle particle = ClientUtils.activeRuneParticles.get(pos);
            particle.setAge(age);
            if (kill || !particle.m_107276_() || particle.getAge() >= 100) {
                ClientUtils.activeRuneParticles.remove(pos);
            }
        } else {
            Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)new RuneCircleType.Options(age, 100, 2.0f, RenderUtils.runeCircleColors[0], RenderUtils.runeCircleColors[1]), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void respawnAnchorPacket(BlockPos blockPos, int charge, boolean isRun) {
        block4: {
            ClientLevel pLevel = Minecraft.m_91087_().f_91073_;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (pLevel == null || player == null) break block4;
            pLevel.m_5594_((Player)player, blockPos, SoundEvents.f_12210_, SoundSource.BLOCKS, 1.0f, 0.75f);
            if (!isRun) {
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123747_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                for (int i = -5; i <= 5; ++i) {
                    pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)blockPos.m_123341_() + 0.5, (double)((float)blockPos.m_123342_() + (float)i / 2.5f) + 0.5, (double)blockPos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                }
            } else {
                for (int i = 0; i < 360; i += 20) {
                    double radians = (double)i * Math.PI / 180.0;
                    pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123813_, (double)blockPos.m_123341_() + Math.sin(radians) * (double)charge * 2.0 + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + Math.cos(radians) * (double)charge * 2.0 + 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static void playParticleAnimation(String method, int playerId, BlockPos pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        switch (method) {
            case "curse": 
            case "curseAnimation": {
                level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), Registry.f_122821_.m_6612_(new ResourceLocation(CurseConfig.curseSound)).orElse(SoundEvents.f_12490_), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                for (int i = 0; i < 360; i += 3) {
                    double radians = (double)i * Math.PI / 180.0;
                    level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50451_.m_49966_()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.65, (double)pos.m_123343_() + 0.5, Math.sin(radians) / 1.5, 0.25, Math.cos(radians) / 1.5);
                }
                break;
            }
            case "totem": 
            case "respawn": {
                level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12513_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                for (int i = 0; i < 900; i += 5) {
                    double radians = (double)i * Math.PI / 180.0;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123767_, (double)pos.m_123341_() + Math.sin(radians) * 0.5 + 0.5, (double)((float)pos.m_123342_() + (float)i / 360.0f), (double)pos.m_123343_() + Math.cos(radians) * 0.5 + 0.5, Math.sin(radians) / 20.0, 0.0, Math.cos(radians) / 20.0);
                }
                break;
            }
        }
    }

    public static void playClientSound(SoundEvent event, float pitch, float volume) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.m_5496_(event, pitch, volume);
        }
    }

    public static void playLocalClientSound(SoundEvent event, float pitch, float volume, double x, double y, double z) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            level.m_7785_(x, y, z, event, SoundSource.MASTER, pitch, volume, false);
        }
    }

    public static void playerTotemAnimation(Item item) {
        GameRenderer gameRenderer = Minecraft.m_91087_().f_91063_;
        if (gameRenderer != null) {
            gameRenderer.m_109113_(new ItemStack(item.arch$holder()));
        }
    }

    public static void syncEffectsPacket(int amplifier, int duration) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.m_7292_(new MobEffectInstance((MobEffect)ModRegistries.IMMORTALITY_CURSE.get(), duration, amplifier));
        }
    }
}

